
/*  @(#)popitopgm.c 1.1 02/02/15
 *
 *  Small filter to convert old format popi image files to raw pgm format
 *  files. The old popi image is given on standard input, and the raw pgm
 *  file is written to standard output.
 *
 *  Command line options:
 *
 *  -x nnn  -  width of the image in pixels.
 *  -y nnn  -  height of the image in pixels.
 *
 *  Popi was originally written by Gerard J. Holzmann - AT&T Bell Labs.
 *  This version is based on the code in his Prentice Hall book,
 *  "Beyond Photography - the digital darkroom," ISBN 0-13-074410-7,
 *  which is copyright (c) 1988 by Bell Telephone Laboratories, Inc.
 *
 *  Copyright (c) 1989-2002 - Rich Burridge, Sun Microsystems Inc.
 *  All rights reserved.
 *
 *  Permission is given to distribute these sources, as long as the
 *  copyright messages are not removed, and no monies are exchanged.
 *
 *  No responsibility is taken for any errors or inaccuracies inherent
 *  either to the comments or the code of this program, but if
 *  reported to me, then an attempt will be made to fix them.
 */

#include <stdio.h>
#include <stdlib.h>
#include "config.h"

#define FPRINTF  (void) fprintf
#define PRINTF   (void) printf


int
main(int argc, char *argv[])
{
    char *progname = argv[0];    /* Name of this program. */
    int c;
    int w = 512;                 /* Default width is 512 pixels. */
    int h = 512;                 /* Default height is 512 pixels. */

    argv++;                      /* Extract command line options (if any). */
    argc--;
    while (argc > 0) {
        switch (argv[0][1]) {
            case 'w' : 
                argv++;            /* New width value. */
                argc--;
                w = atoi(*argv);
                break;

            case 'h' : 
                argv++;            /* New height value. */
                argc--;
                h = atoi(*argv);
                break;

            case 'v' : 
                FPRINTF(stderr, "%s %s\n", progname, VERSION);
                break;

            case '?' : 
              FPRINTF(stderr, "Usage: %s [-w width] [-h height ] [-v] [-?]\n",
                      progname);
              exit(1);
        }
        argc--;
        argv++;
    }

    PRINTF("P5\n%d %d\n255\n", w, h);
    while ((c = getchar()) != EOF) putchar(c);

    return(0);
}
