
/*  @(#)vars.c 1.3 02/02/15
 *
 *  Variable handling routines used by popi.
 *
 *  Popi was originally written by Gerard J. Holzmann - AT&T Bell Labs.
 *  This version is based on the code in his Prentice Hall book,
 *  "Beyond Photography - the digital darkroom," ISBN 0-13-074410-7,
 *  which is copyright (c) 1988 by Bell Telephone Laboratories, Inc.
 *
 *  Copyright (c) 1989-2002 - Jeremy Fitzhardinge
 *  All rights reserved.
 *
 *  Permission is given to distribute these sources, as long as the
 *  copyright messages are not removed, and no monies are exchanged.
 *
 *  No responsibility is taken for any errors or inaccuracies inherent
 *  either to the comments or the code of this program, but if
 *  reported to me, then an attempt will be made to fix them.
 */

#include "popi.h"
#include "expr.h"

#define STRDUP(x) (strcpy(alloc(strlen(x) + 1), (x)))

static int lastvar = 0;

static struct var vars[NUMVARS];


int
allocName(char *n)
{
    int i;

    for (i = 0; i < lastvar; i++) {
        if (!strcmp(vars[i].n, n)) {
            vars[i].r++;
            return(i);
        }
    }

    if (lastvar == NUMVARS-1) {
        run_error(ERR_VAR);
    }

    vars[lastvar].n = STRDUP(n);
    vars[lastvar].r = 0;
    vars[lastvar].slot = lastvar;

    return(lastvar++);
}


void
setvardep(int var, int dep)
{
    findVar(var)->dep = dep;
}


int
getvardep(int var)
{
    return(findVar(var)->dep);
}


void
valVar(int i)
{
  findVar(i)->r++;
}


void
devalVar(int var)
{
    findVar(var)->r--;
}


char *
tmpvar()
{
    static int count = 0;
    char *buf = alloc(10);

    SPRINTF(buf, ".t%04d", count++);

    return(buf);
}


struct var *
findVar(int slot)
{
    int i;

    for (i = 0; i < lastvar; i++) {
        if (vars[i].slot == slot) {
            return(&vars[i]);
        }
    }

    run_error(ERR_NOSLOT);

/*NOTREACHED*/
    return(0);
}


static int
cmpref(struct var *p1, struct var *p2)
{
    return(p1->r - p2->r);
}


void
allocVars()
{
    if (lastvar > 1) {
        qsort(vars, lastvar, sizeof(struct var), 
              (int (*) (const void *, const void *)) cmpref);
    }

    allocRegs(vars, lastvar);
}
