
/*  @(#)expr.h 1.3 02/02/15
 *
 *  Definitions used in the popi yacc grammar.
 *
 *  Popi was originally written by Gerard J. Holzmann - AT&T Bell Labs.
 *  This version is based on the code in his Prentice Hall book,
 *  "Beyond Photography - the digital darkroom," ISBN 0-13-074410-7,
 *  which is copyright (c) 1988 by Bell Telephone Laboratories, Inc.
 *
 *  Copyright (c) 1989-2002 - Rich Burridge, Sun Microsystems Inc.
 *  All rights reserved.
 *
 *  Permission is given to distribute these sources, as long as the
 *  copyright messages are not removed, and no monies are exchanged.
 *
 *  No responsibility is taken for any errors or inaccuracies inherent
 *  either to the comments or the code of this program, but if
 *  reported to me, then an attempt will be made to fix them.
 */

#include <stdio.h>

enum tree {
    T_Abs,      T_Add,     T_And,     T_Assign,  T_Atan,     /*  0 */
    T_Bang,     T_Color,   T_Comb,    T_Comma,   T_Cond,     /*  5 */
    T_Coord,    T_Cos,     T_Debug,   T_Display, T_Div,      /* 10 */
    T_Eq,       T_Explo,   T_Extcmd,  T_File,    T_Fnum,     /* 15 */
    T_Free,     T_Ge,      T_Genep,   T_Genps,   T_Get,      /* 20 */
    T_Gray,     T_Gt,      T_Help,    T_Hypot,   T_Image,    /* 25 */
    T_Inum,     T_Land,    T_Le,      T_List,    T_Logfile,  /* 30 */
    T_Luma,     T_Lor,     T_Lshift,  T_Log,     T_Lt,       /* 35 */
    T_Mapcoord, T_Matte,   T_Melt,    T_Minus,   T_Mod,      /* 40 */
    T_Mono,     T_Mul,     T_Ne,      T_Neg,     T_New,      /* 45 */
    T_Nop,      T_Not,     T_Ofmt,    T_Oil,     T_Or,       /* 50 */
    T_Pang,     T_Plus,    T_Polar,   T_Pow,     T_Prad,     /* 55 */
    T_Put,      T_Quit,    T_Rand,    T_Range,   T_Rcut,     /* 60 */
    T_Read,     T_Rminmax, T_Rwrap,   T_Rshift,  T_Shear,    /* 65 */
    T_Signed,   T_Sin,     T_Size,    T_Slice,   T_Sqr,      /* 70 */
    T_Sqrt,     T_Store,   T_Sub,     T_Tan,     T_Tile,     /* 75 */
    T_Top,      T_Trunc,   T_Undo,    T_VAngle,  T_Var,      /* 80 */
    T_VRadius,  T_Verbose, T_Ver,     T_Write,   T_Xcoord,   /* 85 */
    T_Xor,      T_Ycoord                                     /* 90 */
};

typedef struct Tree Tree;

struct Tree {
    enum tree t;
    int siz;
    int i;
    double d;
    unsigned hash;
    struct Tree *kids[3];
};

typedef enum { Mem, Reg } SClass;

struct var {
    char *n;
    int r;
    int slot;
    SClass sc;
    int v;
    int dep;
};
 
struct builtin {
    char *n;
    enum tree t;
    int a;
    int (*func)();
    int var;
};

/* alloc.c */
extern void *alloc(size_t);
extern void afree(void);

#ifndef offsetof
#define offsetof(t, m)  ((size_t) &((t *) 0)->m)
#endif /*!offsetof*/

/* main.c */
extern int saw_eof;
extern Tree *tree;

/* gen.c */
extern void compile(Tree *);
extern void allocRegs(struct var *, int);
extern int  cost(Tree *);

/* io.c */
extern void showfiles(Tree *);

/* mk.c */
extern Tree *treealloc(int);
extern Tree *mk(enum tree, Tree *, Tree *);
extern Tree *mkCond(Tree *, Tree *, Tree *);
extern Tree *mkCoord(int, Tree *);
extern Tree *mkMapcoord(int, Tree *, Tree *);
extern Tree *mkun(enum tree, void *);
extern Tree *mkInum(int);
extern Tree *mkFnum(double);
extern Tree *mkVar(char *);
extern Tree *mkempty(enum tree);
extern Tree *mkBuiltin(char *, int, ...);
extern Tree *mkAssign(char *, Tree *);
extern Tree *mkTop(Tree *, Tree *, Tree *, Tree *, Tree *);

extern struct builtin builtins[];
extern int nbuiltin;

/* special.c */
extern void debug(Tree *);
extern void displayimg(Tree *);
extern void dolog(Tree *);
extern void dorange(Tree *);
extern void dosigned(Tree *);
extern void dostore(Tree *);
extern void freeimg(Tree *);
extern void genepson(Tree *);
extern void genps(Tree *);
extern void getrgb(Tree *);
extern void help(Tree *);
extern void imtrunc(Tree *);
extern void matte(Tree *);
extern void melt(Tree *);
extern void ofmt(Tree *);
extern void oil(Tree *);
extern void putrgb(Tree *);
extern void readimg(Tree *);
extern void setcolor(Tree *);
extern void setgray(Tree *);
extern void setmono(Tree *);
extern void shear(Tree *);
extern void dosize(Tree *);
extern void slice(Tree *);
extern void stopict(Tree *, int, char *);
extern void tile(Tree *);
extern void undo(Tree *);
extern void verbose(Tree *);
extern void writeimg(Tree *);

/* trig.c */
extern int sin_cache[], cos_cache[], tan_cache[];

extern void cache_trig(void);
extern int isqrt(int);
extern int dist(int, int, int, int);
extern int angle(int, int, int, int);
extern int polar(int, int);
extern int dorand();

/* optimise.c */
extern Tree *opttree(Tree *);

/* colspec.c */
extern void luma(Tree *);
extern void explode(Tree *);
extern void combine(Tree *);
extern void getputrgb(Tree *, int);

/* vars.c */
extern int allocName(char *);
extern struct var *findVar(int);
extern char *tmpvar(void);
extern void allocVars(void);
extern void devalVar(int);
extern void valVar(int);
extern void setvardep(int, int);
extern int getvardep(int);
 
/* dtree.c */
#ifdef TREEDEBUG
extern void dtree(char *, Tree *, int);
#else
#define dtree(a, b, c)
#endif /*TREEDEBUG*/
