
# line 23 "expr.y"

#include <stdio.h>
#include <ctype.h>
#include <values.h>
#include <sys/param.h>
#include "popi.h"
#include "expr.h"

#define RET(x)    return(emit((x)))
#define STRDUP(x) strcpy(alloc(strlen(x)+1), x)

enum word_type { W_Special, W_Function, W_Keyword };

static int check_buf(void);
static int emit(int);
static int Getch(void);
static int GetNumber(int);
static int is_word(enum word_type, char *);
static int parse_default(int);
static int yylex(void);
int yydebug = 1;

static void pushback(int);
static void yyerror(char *);

struct NameToken {
    char *name;
    int token;
};

static double lastfnum;       /* Last floating point number parsed. */
static int lastinum;          /* Last integer number parsed. */

static char buf[MAXLINE];


# line 60 "expr.y"
typedef union
#ifdef __cplusplus
	YYSTYPE
#endif
 {
    Tree *node;
    char *name;
    int num;
} YYSTYPE;
# define TOK_ABS 257
# define TOK_ANGLE 258
# define TOK_AND 259
# define TOK_ATAN 260
# define TOK_BLUE 261
# define TOK_COLOR 262
# define TOK_COMB 263
# define TOK_COMMENT 264
# define TOK_COS 265
# define TOK_DEBUG 266
# define TOK_DISPLAY 267
# define TOK_DIST 268
# define TOK_EQ 269
# define TOK_EXPLO 270
# define TOK_FCON 271
# define TOK_FNAME 272
# define TOK_FREE 273
# define TOK_GE 274
# define TOK_GENEPSON 275
# define TOK_GENPS 276
# define TOK_GET 277
# define TOK_GREEN 278
# define TOK_GRAY 279
# define TOK_HELP 280
# define TOK_HYPOT 281
# define TOK_ICON 282
# define TOK_IMAGE 283
# define TOK_LE 284
# define TOK_LIST 285
# define TOK_LOG 286
# define TOK_LOGFILE 287
# define TOK_LSHIFT 288
# define TOK_LUMA 289
# define TOK_MATTE 290
# define TOK_MELT 291
# define TOK_MONO 292
# define TOK_NE 293
# define TOK_NEW 294
# define TOK_OFMT 295
# define TOK_OIL 296
# define TOK_OR 297
# define TOK_POW 298
# define TOK_PUT 299
# define TOK_QUIT 300
# define TOK_RAND 301
# define TOK_RANGE 302
# define TOK_RCUT 303
# define TOK_READ 304
# define TOK_RED 305
# define TOK_RMINMAX 306
# define TOK_RSHIFT 307
# define TOK_RWRAP 308
# define TOK_SHEAR 309
# define TOK_SIGNED 310
# define TOK_SIN 311
# define TOK_SIZE 312
# define TOK_SLICE 313
# define TOK_SQRT 314
# define TOK_STORE 315
# define TOK_TILE 316
# define TOK_TRUNC 317
# define TOK_UNDO 318
# define TOK_VAR 319
# define TOK_VERBOSE 320
# define TOK_VERSION 321
# define TOK_WRITE 322

#include <inttypes.h>

#ifdef __STDC__
#include <stdlib.h>
#include <string.h>
#define	YYCONST	const
#else
#include <malloc.h>
#include <memory.h>
#define	YYCONST
#endif

#include <values.h>

#if defined(__cplusplus) || defined(__STDC__)

#if defined(__cplusplus) && defined(__EXTERN_C__)
extern "C" {
#endif
#ifndef yyerror
#if defined(__cplusplus)
	void yyerror(YYCONST char *);
#endif
#endif
#ifndef yylex
	int yylex(void);
#endif
	int yyparse(void);
#if defined(__cplusplus) && defined(__EXTERN_C__)
}
#endif

#endif

#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
YYSTYPE yylval;
YYSTYPE yyval;
typedef int yytabelem;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#if YYMAXDEPTH > 0
int yy_yys[YYMAXDEPTH], *yys = yy_yys;
YYSTYPE yy_yyv[YYMAXDEPTH], *yyv = yy_yyv;
#else	/* user does initial allocation */
int *yys;
YYSTYPE *yyv;
#endif
static int yymaxdepth = YYMAXDEPTH;
# define YYERRCODE 256

# line 283 "expr.y"


static struct NameToken SpecialToks[] = {      /* Also update popi.man. */
    { "color",       TOK_COLOR    },
    { "combine",     TOK_COMB     },
    { "debug",       TOK_DEBUG    },
    { "display",     TOK_DISPLAY  },
    { "exit",        TOK_QUIT     },
    { "explode",     TOK_EXPLO    },
    { "free",        TOK_FREE     },
    { "genepson",    TOK_GENEPSON },
    { "genps",       TOK_GENPS    },
    { "get",         TOK_GET      },
    { "grayscale",   TOK_GRAY     },
    { "help",        TOK_HELP     },
    { "list",        TOK_LIST     },
    { "logfile",     TOK_LOGFILE  },
    { "luma",        TOK_LUMA     },
    { "matte",       TOK_MATTE    },
    { "melt",        TOK_MELT     },
    { "monochrome",  TOK_MONO     },
    { "ofmt",        TOK_OFMT     },
    { "oil",         TOK_OIL      },
    { "put",         TOK_PUT      },
    { "quit",        TOK_QUIT     },
    { "range",       TOK_RANGE    },
    { "read",        TOK_READ     },
    { "shear",       TOK_SHEAR    },
    { "signed",      TOK_SIGNED   },
    { "size",        TOK_SIZE     },
    { "slice",       TOK_SLICE    },
    { "store",       TOK_STORE    },
    { "tile",        TOK_TILE     },
    { "truncate",    TOK_TRUNC    },
    { "undo",        TOK_UNDO     },
    { "verbose",     TOK_VERBOSE  },
    { "version",     TOK_VERSION  },
    { "write",       TOK_WRITE    },
    { (char *) 0,    0            }
};

static struct NameToken FuncToks[] = {         /* Also update popi.man. */
    { "abs",         TOK_ABS      },
    { "angle",       TOK_ANGLE    },
    { "atan",        TOK_ATAN     },
    { "cos",         TOK_COS      },
    { "dist",        TOK_DIST     },
    { "hypot",       TOK_HYPOT    },
    { "log",         TOK_LOG      },
    { "rand",        TOK_RAND     },
    { "sin",         TOK_SIN      },
    { "sqrt",        TOK_SQRT     },
    { (char *) 0,    0            }
};

static struct NameToken KeywordToks[] = {      /* Also update popi.man. */
    { "blue",        TOK_BLUE     },
    { "cut",         TOK_RCUT     },
    { "green",       TOK_GREEN    },
    { "minmax",      TOK_RMINMAX  },
    { "new",         TOK_NEW      },
    { "red",         TOK_RED      },
    { "wrap",        TOK_RWRAP    },
    { (char *) 0,    0            }
};


static int
Getch()
{
    int c;

    if (InputStream == (FILE *) 0) {
        if (SaveChar == '\0') {
            c = disp_getchar();
        } else { 
            c = SaveChar;
            SaveChar = '\0';
        }
    } else {
        c = getc(InputStream);
    }
 
    OldPos = CharPos;
           
    if (c == '\t') {
        CharPos = (CharPos - 1) % 8 + 8;
    } else if (c == '\n') {
        CharPos = 0;
    } else {
        ++CharPos;
    }

    DEBUG((Debug, "Getch() => '%c'\n", c));

    if (LogStr && CharPos != OldPos) {
        PUTC(c, LogStr);
    }

    return(c);
}


static int
GetNumber(int first)
{
    double fract;
    int c, num;

    num = first - '0';
    fract = 0.0;
    while (isdigit(c = Getch())) {
        num = 10 * num + c - '0';
    }

    if (c == '.') {
        double div = 10.0;

        while (isdigit(c = Getch())) {
            fract += (c - '0') / div;
            div *= 10.0;
        }
    }
    pushback(c);
    if (fract == 0.0) {
        lastinum = num;
        return(TOK_ICON);
    }
    lastfnum = (double) num + fract;

    return(TOK_FCON);
}


static int
emit(int token)
{
    HaveToken = 1;

    return(token);
}
 
 
static void
pushback(int c)
{
    DEBUG((Debug, "pushback('%c')\n", c));
    if (InputStream == (FILE *) 0) {
        SaveChar = c;
    } else {
        UNGETC(c, InputStream);
    }
    CharPos = OldPos;
}


static int
is_word(enum word_type w, char *buf)
{
    struct NameToken *nt = NULL;
    struct NameToken *start = NULL;
    int cnt, len; 
    int token = 0;

    if (w == W_Special) {
        start = nt = &SpecialToks[0];
    } else if (w == W_Function) {
        start = nt = &FuncToks[0];
    } else if (w == W_Keyword) {
        start = nt = &KeywordToks[0];
    }
    for (cnt = 0; nt->name; nt++) {
        if (strncmp(buf, nt->name, strlen(buf)) == 0) {  
            token = nt->token;
            cnt++;
        }  
    }
    if (!cnt) {
        return(0);
    }
    if (cnt > 1) {
        SPRINTF(ErrBuf, "Operation '%s' ambiguous (", buf);
        for (nt = start; nt->name; nt++) {
            if (strncmp(buf, nt->name, strlen(buf)) == 0) {
                STRCAT(ErrBuf, nt->name);
                STRCAT(ErrBuf, ", ");
            }
        }
        len = strlen(ErrBuf);
        ErrBuf[len-2] = ')';
        ErrBuf[len-1] = '\n';
        error(ERR_PARSE);
        return(0);
    }

    return(token);
}


static int
yylex()
{
    char *l;
    int c, i, special;

    while ((c = Getch()) == ' ' || c == '\t') {
        continue;
    }
    TokPos = CharPos;
    switch (c) {
        case EOF :
            saw_eof = 1;
            RET(0);

        case ':' :
            special = c;
            if (HaveToken) {
                RET(c);
            }
            l = buf;
            while (isalnum(c = Getch())) {
                *l++ = c;
            }
            pushback(c);
            *l = '\0';
            if ((i = is_word(W_Special, buf))) {
                RET(i);
            }
            RET(special);

        case '#' :
            do {
                c = Getch();
            } while (c != '\n');
            pushback('\n');
            RET(TOK_COMMENT);

        case '\n' :
        case '?' :
        case '-' :
        case '+' :
        case '/' :
        case '%' :
        case '~' :
        case '^' :
        case '(' :
        case ')' :
        case '[' :
        case ']' :
        case '{' :
        case '}' :
        case ',' :
        case '$' :
        case ';' :
            RET(c);

        case '*' :
            if ((c = Getch()) == '*') {
                RET(TOK_POW);
            }
            pushback(c);
            RET('*');

        case '&' :
            if ((c = Getch()) == '&') {
                RET(TOK_AND);
            }
            pushback(c);
            RET('&');

        case '|' :
            if ((c = Getch()) == '|') {
                RET(TOK_OR);
            }
            pushback(c);
            RET('|');

        case '>' :
            if ((c = Getch()) == '>') {
                RET(TOK_RSHIFT);
            } else if (c == '=') {
                RET(TOK_GE);
            }
            pushback(c);
            RET('>');

        case '<' :
            if ((c = Getch()) == '<') {
                RET(TOK_LSHIFT);
            } else if (c == '=') {
                RET(TOK_LE);
            }
            pushback(c);
            RET('<');

        case '=' : 
            if ((c = Getch()) == '=') {
                RET(TOK_EQ);
            }
            pushback(c);
            RET('=');

        case '!' : 
            if ((c = Getch()) == '=') {
                RET(TOK_NE);
            }
            pushback(c);
            RET('!');

        case '\"' : 
            l = lastfname;
            while ((c = Getch()) != '\"' && c != '\n' && c != EOF) {
                *l++ = c;
            }
            if (c != '\"') {
                pushback(c);
            }
            *l = '\0';
            yylval.name = STRDUP(lastfname);
            RET(TOK_FNAME);

        default : 
            RET(parse_default(c));
    }
}


static int
parse_default(int c)
{
    char *l;

    if (isdigit(c)) {
        return(GetNumber(c));
    } else {
        l = lastimage;
        for (;;) {
            *l++ = c;
            switch (c = Getch()) {
                case EOF  :
                case ' '  :
                case '\t' :
                case '\n' :
                case '?'  :
                case ':'  :
                case '-'  :
                case '+'  :
                case '*'  :
                case '/'  :
                case '%'  :
                case '~'  :
                case '^'  :
                case '('  :
                case ')'  :
                case '<'  :
                case '>'  :
                case '['  :
                case ']'  :
                case '&'  :
                case '|'  :
                case '='  :
                case '!'  :
                case '\"' :
                case ','  :
                case ';'  :
                case '#'  :
                case '{'  :
                case '}'  : 
                    pushback(c);
                    *l = '\0';
                    return(check_buf());
            }
        }
    }
}


static int
check_buf()
{
    int i;
    int reply = TOK_IMAGE;

    if (strlen(lastimage) == 1) {
        switch (*lastimage) {  
            case 'x' :
            case 'y' :
            case 'u' :
            case 'f' :
            case 'q' :
            case 'w' :
            case 'r' :
            case 'a' : 
                return(*lastimage);

            case 'X' : 
                lastinum = CurNew->width - 1;
                return(TOK_ICON);

            case 'Y' : 
                lastinum = CurNew->height - 1;
                return(TOK_ICON);

            case 'A' : 
                lastinum = MAX_ANG;
                return(TOK_ICON);

            case 'R' : 
                lastinum = dist(0, 0, CurNew->width / 2, CurNew->height / 2);
                return(TOK_ICON);

            case 'Z' : 
                lastinum = Zmax;
                return(TOK_ICON);

            case 'T' : 
                lastinum = MAX_TRIG;
                return(TOK_ICON);
        }
    }

    if ((i = is_word(W_Keyword, lastimage))) {
        reply = i;
    } else if ((i = is_word(W_Function, lastimage))) {
        reply = i;
    }
    if (reply != TOK_IMAGE) {
        yylval.name = STRDUP(lastimage);
    }

    return(reply);
}


static void
yyerror(char *err)
{
    STRCPY(ErrBuf, err);
    error(ERR_PARSE);
}
static YYCONST yytabelem yyexca[] ={
-1, 0,
	0, 4,
	259, 127,
	269, 127,
	274, 127,
	284, 127,
	288, 127,
	293, 127,
	297, 127,
	298, 127,
	307, 127,
	59, 127,
	124, 127,
	94, 127,
	38, 127,
	62, 127,
	60, 127,
	42, 127,
	47, 127,
	37, 127,
	123, 127,
	91, 127,
	-2, 0,
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 146
# define YYLAST 503
static YYCONST yytabelem yyact[]={

     6,   128,   156,   119,   129,   163,   130,   144,   150,   153,
    95,   152,   102,    94,   136,   102,   186,   175,   108,    61,
   118,   157,   106,    74,   107,   135,    83,    64,    62,   106,
    78,   107,   151,    72,     6,    73,    63,    59,   147,    96,
    60,   134,    99,    96,   148,   145,    57,   117,    58,    52,
    97,   143,   183,    12,    56,    54,   146,    65,   244,    96,
   243,   235,   234,   233,   232,   228,   231,    77,   149,   224,
   230,   229,   181,   227,    98,   180,    96,   242,    96,    96,
    96,    96,    96,   226,    96,    96,    96,    69,    96,   158,
    74,   159,    13,    83,   216,   179,   105,    78,    96,   106,
    72,   107,    73,    15,    11,   241,   178,    14,   177,    10,
    67,    68,    96,   104,   176,   174,    75,    74,   173,   116,
    83,   114,   115,    93,    78,    91,   127,    72,   171,    73,
   164,   167,   168,   169,   170,   110,   103,   131,     2,   109,
   162,    -1,    66,    92,    79,   160,   182,    84,   142,   124,
   161,    76,    53,     9,    69,     8,   133,   126,     7,     4,
     1,   140,     0,   141,   190,     0,     0,   120,     0,     0,
     0,   165,   204,   205,   206,   207,   193,    67,    68,     0,
     0,    69,     0,    75,     0,   208,   209,   201,   212,   213,
   214,   202,   203,   195,   199,   210,   211,   200,   165,   196,
   197,     0,   198,     0,    67,    68,     0,     0,     0,     0,
    75,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,   215,     0,   154,     0,     0,     0,     0,     0,     0,
     0,     0,     0,   155,    16,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     3,    85,     0,     0,
    81,     0,    18,    19,     5,    86,    20,    21,   108,   101,
    22,    71,   101,    23,     0,    24,    25,    26,     0,    27,
    28,    80,    70,    82,     0,    29,    87,    30,   238,    31,
    32,    33,    34,     0,    17,    35,    36,     0,     5,    37,
    38,    90,    39,     0,    40,     0,     0,     0,     0,    41,
    42,    88,    43,    44,    89,    45,    46,    47,    48,    55,
    49,    50,    51,   172,    85,     0,     0,    81,     0,     0,
     0,     0,    86,     0,     0,     0,     0,     0,    71,     0,
     0,     0,     0,   184,   185,     0,     0,     0,    80,    70,
    82,    85,     0,    87,    81,     0,     0,     0,     0,    86,
     0,     0,     0,     0,     0,    71,     0,     0,    90,   100,
     0,     0,     0,     0,     0,    80,    70,    82,    88,     0,
    87,    89,     0,     0,     0,     0,    55,     0,     0,     0,
     0,   111,   112,   113,     0,    90,     0,     0,     0,     0,
     0,   121,   122,   123,     0,    88,   125,     0,    89,     0,
     0,   132,     0,   166,   137,   138,   139,     0,   217,   218,
     0,   219,   220,   221,   222,   223,     0,     0,   225,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,   236,   237,     0,   239,   240,     0,     0,     0,     0,
     0,     0,     0,     0,   187,   188,   189,     0,     0,     0,
     0,     0,     0,     0,     0,     0,   191,     0,     0,     0,
     0,   192,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,   194 };
static YYCONST yytabelem yypact[]={

   -10,-10000000,-10000000,   115,    24,   113,-10000000,-10000000,-10000000,-10000000,
  -270,  -273,-10000000,-10000000,-10000000,-10000000,     0,   -49,-10000000,   -24,
   -14,   -21,   -24,   -24,  -254,  -254,  -258,-10000000,-10000000,-10000000,
   -14,   -24,   -24,   -24,-10000000,    56,   -24,  -258,-10000000,  -302,
  -254,   -24,    56,  -257,   -24,   -24,   -24,    56,-10000000,    56,
-10000000,  -254,-10000000,   -12,  -252,    -5,   -86,   -50,    30,  -261,
   -51,  -286,    46,   103,  -293,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,    84,    84,    84,    84,    84,   -49,    57,-10000000,
    78,    75,-10000000,  -265,-10000000,    74,    68,    66,    55,    35,
    32,-10000000,-10000000,-10000000,-10000000,-10000000,    57,    -9,    57,    57,
-10000000,-10000000,  -266,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,   -24,   -24,   -24,-10000000,-10000000,-10000000,
-10000000,-10000000,  -257,-10000000,-10000000,-10000000,   -24,-10000000,-10000000,-10000000,
-10000000,   -24,-10000000,-10000000,  -257,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,   -24,    57,    84,    84,    84,    84,    84,    84,
    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,
    84,    84,    84,    84,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,    53,    57,    57,-10000000,    57,    57,    57,    57,
    57,    28,-10000000,    57,    39,    29,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,     7,   -86,   -86,  -252,   -50,
    30,  -261,   -51,   -51,  -286,  -286,  -286,  -286,    46,    46,
   103,   103,  -293,  -293,  -293,-10000000,-10000000,    27,    26,    25,
    23,    22,    21,    20,-10000000,     0,    57,    57,    57,    57,
    57,-10000000,-10000000,-10000000,-10000000,-10000000,   -20,   -16,-10000000,    19,
    17,-10000000,-10000000,-10000000,-10000000 };
static YYCONST yytabelem yypgo[]={

     0,   160,   138,   159,   158,   155,   153,   234,    49,   152,
    55,    54,    46,    48,    37,    40,    19,    28,    36,    27,
    57,   151,   147,   144,   142,   141,   139,   359,    96,    50,
   113,    41,   136,   126,   119,    67 };
static YYCONST yytabelem yyr1[]={

     0,     1,     1,     1,     2,     2,     2,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     4,     5,     6,     6,
     6,     6,     6,     6,     6,     6,     6,     6,     6,     6,
     6,     6,     6,     6,     6,     6,     6,     6,     6,     6,
     6,     6,     6,     6,     6,     6,     6,     6,     6,     6,
     6,     6,     7,     7,     8,     8,     9,     9,    10,    10,
    10,    11,    11,    12,    12,    13,    13,    14,    14,    14,
    15,    15,    15,    15,    15,    16,    16,    16,    17,    17,
    17,    18,    18,    18,    18,    19,    19,    20,    20,    20,
    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,
    20,    20,    25,    25,    25,    24,    24,    24,    23,    23,
    23,    23,    23,    23,    22,    21,    21,    21,    26,    26,
    26,    32,    32,    32,    31,    31,    31,    35,    35,    35,
    27,    27,    27,    28,    29,    29,    29,    33,    33,    33,
    34,    34,    34,    30,    30,    30 };
static YYCONST yytabelem yyr2[]={

     0,     3,     5,     5,     1,     5,     3,     2,     2,     2,
     5,     5,     3,     3,     3,     3,     3,     9,     3,     5,
     5,     5,     5,     5,     7,     7,     7,     3,     3,     3,
     5,     5,     7,     5,     3,     5,     5,     7,     3,     5,
     7,     5,     5,     7,     5,     5,     5,     5,     3,     5,
     3,     7,     2,     7,     2,    11,     2,     7,     2,     7,
     7,     2,     7,     2,     7,     2,     7,     2,     7,     7,
     2,     7,     7,     7,     7,     2,     7,     7,     2,     7,
     7,     2,     7,     7,     7,     2,     7,     2,     3,     3,
     3,     3,     3,     3,     5,     5,     5,     5,     5,     5,
     3,     7,     2,    21,    21,     2,    13,    13,     2,     9,
     9,     9,     9,     9,     7,     3,     3,     3,     1,     2,
     2,     1,     2,     2,     1,     3,     3,     1,     3,     5,
     1,     3,     5,     3,     1,    11,    11,     3,     3,     3,
     3,     3,     3,     1,     3,     3 };
static YYCONST yytabelem yychk[]={

-10000000,    -1,    -2,   256,    -3,   264,    10,    -4,    -5,    -6,
   119,   114,    63,   102,   117,   113,    -7,   294,   262,   263,
   266,   267,   270,   273,   275,   276,   277,   279,   280,   285,
   287,   289,   290,   291,   292,   295,   296,   299,   300,   302,
   304,   309,   310,   312,   313,   315,   316,   317,   318,   320,
   321,   322,    -8,    -9,   -10,   319,   -11,   -12,   -13,   -14,
   -15,   -16,   -17,   -18,   -19,   -20,   -24,   120,   121,    97,
   282,   271,    43,    45,    33,   126,   -21,   -35,    40,   -23,
   281,   260,   283,    36,   -22,   257,   265,   286,   311,   314,
   301,    10,    -2,    10,   283,   283,    59,   -29,   123,    91,
   -27,   283,    36,   -32,   -30,   -28,    43,    45,   272,   -26,
   -30,   -27,   -27,   -27,   -28,   -28,   -34,   305,   278,   261,
   -32,   -27,   -27,   -27,   -30,   -27,   -34,   -33,   303,   306,
   308,   -28,   -27,   -30,   -31,   282,   271,   -27,   -27,   -27,
   -30,   -30,   -28,    63,   259,   297,    61,   124,    94,    38,
   269,   293,    62,    60,   274,   284,   288,   307,    43,    45,
    42,    47,    37,   298,   -20,   114,   319,   -20,   -20,   -20,
   -20,   -29,    -7,    40,    40,   282,    40,    40,    40,    40,
    40,    40,    -8,    61,    -7,    -7,   282,   -27,   -27,   -27,
   -31,   -27,   -27,   -31,   -27,    -8,   -11,   -11,   -10,   -12,
   -13,   -14,   -15,   -15,   -16,   -16,   -16,   -16,   -17,   -17,
   -18,   -18,   -19,   -19,   -19,   -20,    41,    -7,    -7,    -7,
    -7,    -7,    -7,    -7,    41,    -7,    44,    44,    58,    44,
    44,    41,    41,    41,    41,    41,    -7,    -7,    -8,    -7,
    -7,   125,    93,    41,    41 };
static YYCONST yytabelem yydef[]={

    -2,    -2,     1,     0,     4,     0,     6,     7,     8,     9,
     0,    90,    12,    13,    14,    15,    16,   134,    18,   130,
   121,   118,   130,   130,     0,     0,     0,    27,    28,    29,
   121,   130,   130,   130,    34,   143,   130,     0,    38,     0,
     0,   130,   143,   124,   130,   130,   130,   143,    48,   143,
    50,     0,    52,    54,    56,   100,    58,    61,    63,    65,
    67,    70,    75,    78,    81,    85,    87,    88,    89,    91,
    92,    93,   127,   116,   115,   117,   127,   134,   127,   105,
     0,     0,   128,     0,   108,     0,     0,     0,     0,     0,
     0,     2,     3,     5,    10,    11,   127,     0,   127,   127,
    19,   131,     0,    20,   122,   123,   144,   145,   133,    21,
   119,   120,    22,    23,   130,   130,   130,   140,   141,   142,
    30,    31,   124,    33,    35,    36,   130,    39,   137,   138,
   139,   130,    41,    42,   124,   125,   126,    44,    45,    46,
    47,    49,   130,   127,   127,   127,   127,   127,   127,   127,
   127,   127,   127,   127,   127,   127,   127,   127,   127,   127,
   127,   127,   127,   127,    94,    90,   100,    95,    96,    97,
    98,    99,     0,   127,   127,   129,   127,   127,   127,   127,
   127,     0,    53,   127,     0,     0,   132,    24,    25,    26,
    32,    37,    40,    43,    51,     0,    59,    60,    57,    62,
    64,    66,    68,    69,    71,    72,    73,    74,    76,    77,
    79,    80,    82,    83,    84,    86,   101,     0,     0,     0,
     0,     0,     0,     0,   114,    17,   127,   127,   127,   127,
   127,   109,   110,   111,   112,   113,     0,     0,    55,     0,
     0,   135,   136,   106,   107 };
typedef struct
#ifdef __cplusplus
	yytoktype
#endif
{ char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"TOK_ABS",	257,
	"TOK_ANGLE",	258,
	"TOK_AND",	259,
	"TOK_ATAN",	260,
	"TOK_BLUE",	261,
	"TOK_COLOR",	262,
	"TOK_COMB",	263,
	"TOK_COMMENT",	264,
	"TOK_COS",	265,
	"TOK_DEBUG",	266,
	"TOK_DISPLAY",	267,
	"TOK_DIST",	268,
	"TOK_EQ",	269,
	"TOK_EXPLO",	270,
	"TOK_FCON",	271,
	"TOK_FNAME",	272,
	"TOK_FREE",	273,
	"TOK_GE",	274,
	"TOK_GENEPSON",	275,
	"TOK_GENPS",	276,
	"TOK_GET",	277,
	"TOK_GREEN",	278,
	"TOK_GRAY",	279,
	"TOK_HELP",	280,
	"TOK_HYPOT",	281,
	"TOK_ICON",	282,
	"TOK_IMAGE",	283,
	"TOK_LE",	284,
	"TOK_LIST",	285,
	"TOK_LOG",	286,
	"TOK_LOGFILE",	287,
	"TOK_LSHIFT",	288,
	"TOK_LUMA",	289,
	"TOK_MATTE",	290,
	"TOK_MELT",	291,
	"TOK_MONO",	292,
	"TOK_NE",	293,
	"TOK_NEW",	294,
	"TOK_OFMT",	295,
	"TOK_OIL",	296,
	"TOK_OR",	297,
	"TOK_POW",	298,
	"TOK_PUT",	299,
	"TOK_QUIT",	300,
	"TOK_RAND",	301,
	"TOK_RANGE",	302,
	"TOK_RCUT",	303,
	"TOK_READ",	304,
	"TOK_RED",	305,
	"TOK_RMINMAX",	306,
	"TOK_RSHIFT",	307,
	"TOK_RWRAP",	308,
	"TOK_SHEAR",	309,
	"TOK_SIGNED",	310,
	"TOK_SIN",	311,
	"TOK_SIZE",	312,
	"TOK_SLICE",	313,
	"TOK_SQRT",	314,
	"TOK_STORE",	315,
	"TOK_TILE",	316,
	"TOK_TRUNC",	317,
	"TOK_UNDO",	318,
	"TOK_VAR",	319,
	"TOK_VERBOSE",	320,
	"TOK_VERSION",	321,
	"TOK_WRITE",	322,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
	"popi : comment",
	"popi : error '\n'",
	"popi : cmd comment",
	"comment : /* empty */",
	"comment : TOK_COMMENT '\n'",
	"comment : '\n'",
	"cmd : dst",
	"cmd : mapdst",
	"cmd : special",
	"cmd : 'w' TOK_IMAGE",
	"cmd : 'r' TOK_IMAGE",
	"cmd : '?'",
	"cmd : 'f'",
	"cmd : 'u'",
	"cmd : 'q'",
	"dst : expr",
	"mapdst : TOK_NEW coord '=' expr",
	"special : TOK_COLOR",
	"special : TOK_COMB image",
	"special : TOK_DEBUG logfile",
	"special : TOK_DISPLAY display",
	"special : TOK_EXPLO image",
	"special : TOK_FREE image",
	"special : TOK_GENEPSON dfile image",
	"special : TOK_GENPS dfile image",
	"special : TOK_GET rgbcomp image",
	"special : TOK_GRAY",
	"special : TOK_HELP",
	"special : TOK_LIST",
	"special : TOK_LOGFILE logfile",
	"special : TOK_LUMA image",
	"special : TOK_MATTE image number",
	"special : TOK_MELT image",
	"special : TOK_MONO",
	"special : TOK_OFMT dir",
	"special : TOK_OIL image",
	"special : TOK_PUT rgbcomp image",
	"special : TOK_QUIT",
	"special : TOK_RANGE policy",
	"special : TOK_READ dfile image",
	"special : TOK_SHEAR image",
	"special : TOK_SIGNED dir",
	"special : TOK_SIZE number number",
	"special : TOK_SLICE image",
	"special : TOK_STORE image",
	"special : TOK_TILE image",
	"special : TOK_TRUNC dir",
	"special : TOK_UNDO",
	"special : TOK_VERBOSE dir",
	"special : TOK_VERSION",
	"special : TOK_WRITE dfile image",
	"expr : co",
	"expr : expr ';' co",
	"co : as",
	"co : as '?' co ':' co",
	"as : ss",
	"as : TOK_VAR '=' ss",
	"ss : or",
	"ss : ss TOK_AND or",
	"ss : ss TOK_OR or",
	"or : xor",
	"or : or '|' xor",
	"xor : and",
	"xor : xor '^' and",
	"and : eq",
	"and : and '&' eq",
	"eq : rel",
	"eq : eq TOK_EQ rel",
	"eq : eq TOK_NE rel",
	"rel : shift",
	"rel : rel '>' shift",
	"rel : rel '<' shift",
	"rel : rel TOK_GE shift",
	"rel : rel TOK_LE shift",
	"shift : plus",
	"shift : shift TOK_LSHIFT plus",
	"shift : shift TOK_RSHIFT plus",
	"plus : times",
	"plus : plus '+' times",
	"plus : plus '-' times",
	"times : pow",
	"times : times '*' pow",
	"times : times '/' pow",
	"times : times '%' pow",
	"pow : factor",
	"pow : pow TOK_POW factor",
	"factor : fncall2",
	"factor : 'x'",
	"factor : 'y'",
	"factor : 'r'",
	"factor : 'a'",
	"factor : TOK_ICON",
	"factor : TOK_FCON",
	"factor : '+' factor",
	"factor : '-' factor",
	"factor : '!' factor",
	"factor : '~' factor",
	"factor : unaryop factor",
	"factor : file coord",
	"factor : TOK_VAR",
	"factor : '(' expr ')'",
	"fncall4 : fncall2",
	"fncall4 : TOK_DIST '(' expr ',' expr ',' expr ',' expr ')'",
	"fncall4 : TOK_ANGLE '(' expr ',' expr ',' expr ',' expr ')'",
	"fncall2 : fncall1",
	"fncall2 : TOK_HYPOT '(' expr ',' expr ')'",
	"fncall2 : TOK_ATAN '(' expr ',' expr ')'",
	"fncall1 : fncall0",
	"fncall1 : TOK_ABS '(' expr ')'",
	"fncall1 : TOK_COS '(' expr ')'",
	"fncall1 : TOK_LOG '(' expr ')'",
	"fncall1 : TOK_SIN '(' expr ')'",
	"fncall1 : TOK_SQRT '(' expr ')'",
	"fncall0 : TOK_RAND '(' ')'",
	"unaryop : '!'",
	"unaryop : '-'",
	"unaryop : '~'",
	"display : /* empty */",
	"display : dir",
	"display : image",
	"logfile : /* empty */",
	"logfile : dir",
	"logfile : dfile",
	"number : /* empty */",
	"number : TOK_ICON",
	"number : TOK_FCON",
	"file : /* empty */",
	"file : TOK_IMAGE",
	"file : '$' TOK_ICON",
	"image : /* empty */",
	"image : TOK_IMAGE",
	"image : '$' TOK_ICON",
	"dfile : TOK_FNAME",
	"coord : /* empty */",
	"coord : '{' expr ',' expr '}'",
	"coord : '[' expr ',' expr ']'",
	"policy : TOK_RCUT",
	"policy : TOK_RMINMAX",
	"policy : TOK_RWRAP",
	"rgbcomp : TOK_RED",
	"rgbcomp : TOK_GREEN",
	"rgbcomp : TOK_BLUE",
	"dir : /* empty */",
	"dir : '+'",
	"dir : '-'",
};
#endif /* YYDEBUG */
# line	1 "/usr/ccs/bin/yaccpar"
/*
 * Copyright (c) 1993 by Sun Microsystems, Inc.
 */

#pragma ident	"@(#)yaccpar	6.16	99/01/20 SMI"

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab
#define YYACCEPT	return(0)
#define YYABORT		return(1)
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#define YYNEW(type)	malloc(sizeof(type) * yynewmax)
#define YYCOPY(to, from, type) \
	(type *) memcpy(to, (char *) from, yymaxdepth * sizeof (type))
#define YYENLARGE( from, type) \
	(type *) realloc((char *) from, yynewmax * sizeof(type))
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-10000000)

/*
** global variables used by the parser
*/
YYSTYPE *yypv;			/* top of value stack */
int *yyps;			/* top of state stack */

int yystate;			/* current state */
int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */
int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */



#ifdef YYNMBCHARS
#define YYLEX()		yycvtok(yylex())
/*
** yycvtok - return a token if i is a wchar_t value that exceeds 255.
**	If i<255, i itself is the token.  If i>255 but the neither 
**	of the 30th or 31st bit is on, i is already a token.
*/
#if defined(__STDC__) || defined(__cplusplus)
int yycvtok(int i)
#else
int yycvtok(i) int i;
#endif
{
	int first = 0;
	int last = YYNMBCHARS - 1;
	int mid;
	wchar_t j;

	if(i&0x60000000){/*Must convert to a token. */
		if( yymbchars[last].character < i ){
			return i;/*Giving up*/
		}
		while ((last>=first)&&(first>=0)) {/*Binary search loop*/
			mid = (first+last)/2;
			j = yymbchars[mid].character;
			if( j==i ){/*Found*/ 
				return yymbchars[mid].tvalue;
			}else if( j<i ){
				first = mid + 1;
			}else{
				last = mid -1;
			}
		}
		/*No entry in the table.*/
		return i;/* Giving up.*/
	}else{/* i is already a token. */
		return i;
	}
}
#else/*!YYNMBCHARS*/
#define YYLEX()		yylex()
#endif/*!YYNMBCHARS*/

/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
#if defined(__STDC__) || defined(__cplusplus)
int yyparse(void)
#else
int yyparse()
#endif
{
	register YYSTYPE *yypvt = 0;	/* top of value stack for $vars */

#if defined(__cplusplus) || defined(lint)
/*
	hacks to please C++ and lint - goto's inside
	switch should never be executed
*/
	static int __yaccpar_lint_hack__ = 0;
	switch (__yaccpar_lint_hack__)
	{
		case 1: goto yyerrlab;
		case 2: goto yynewstate;
	}
#endif

	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

#if YYMAXDEPTH <= 0
	if (yymaxdepth <= 0)
	{
		if ((yymaxdepth = YYEXPAND(0)) <= 0)
		{
			yyerror("yacc initialization error");
			YYABORT;
		}
	}
#endif

	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */
	goto yystack;	/* moved from 6 lines above to here to please C++ */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
			/*
			** reallocate and recover.  Note that pointers
			** have to be reset, or bad things will happen
			*/
			long yyps_index = (yy_ps - yys);
			long yypv_index = (yy_pv - yyv);
			long yypvt_index = (yypvt - yyv);
			int yynewmax;
#ifdef YYEXPAND
			yynewmax = YYEXPAND(yymaxdepth);
#else
			yynewmax = 2 * yymaxdepth;	/* double table size */
			if (yymaxdepth == YYMAXDEPTH)	/* first time growth */
			{
				char *newyys = (char *)YYNEW(int);
				char *newyyv = (char *)YYNEW(YYSTYPE);
				if (newyys != 0 && newyyv != 0)
				{
					yys = YYCOPY(newyys, yys, int);
					yyv = YYCOPY(newyyv, yyv, YYSTYPE);
				}
				else
					yynewmax = 0;	/* failed */
			}
			else				/* not first time */
			{
				yys = YYENLARGE(yys, int);
				yyv = YYENLARGE(yyv, YYSTYPE);
				if (yys == 0 || yyv == 0)
					yynewmax = 0;	/* failed */
			}
#endif
			if (yynewmax <= yymaxdepth)	/* tables not expanded */
			{
				yyerror( "yacc stack overflow" );
				YYABORT;
			}
			yymaxdepth = yynewmax;

			yy_ps = yys + yyps_index;
			yy_pv = yyv + yypv_index;
			yypvt = yyv + yypvt_index;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = YYLEX() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			printf( "Received token " );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = YYLEX() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				printf( "Received token " );
				if ( yychar == 0 )
					printf( "end-of-file\n" );
				else if ( yychar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register YYCONST int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
			skip_init:
				yynerrs++;
				/* FALLTHRU */
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					printf( "Error recovery discards " );
					if ( yychar == 0 )
						printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 1:
# line 98 "expr.y"
{ tree = NULL; YYACCEPT;        } break;
case 2:
# line 99 "expr.y"
{ tree = NULL; YYABORT;         } break;
case 3:
# line 100 "expr.y"
{ tree = yypvt[-1].node;   YYACCEPT;        } break;
case 4:
# line 102 "expr.y"
{ yyval.node = NULL;                     } break;
case 5:
# line 103 "expr.y"
{ yyval.node = NULL;                     } break;
case 6:
# line 104 "expr.y"
{ yyval.node = NULL;                     } break;
case 10:
# line 109 "expr.y"
{ yyval.node = mkun(T_Write, yypvt[-0].name);        } break;
case 11:
# line 110 "expr.y"
{ yyval.node = mkun(T_Read,  yypvt[-0].name);        } break;
case 12:
# line 111 "expr.y"
{ yyval.node = mkempty(T_Help);          } break;
case 13:
# line 112 "expr.y"
{ yyval.node = mkempty(T_List);          } break;
case 14:
# line 113 "expr.y"
{ yyval.node = mkempty(T_Undo);          } break;
case 15:
# line 114 "expr.y"
{ yyval.node = mkempty(T_Quit);          } break;
case 16:
# line 116 "expr.y"
{ yyval.node = mkMapcoord(0, NULL, yypvt[-0].node);  } break;
case 17:
# line 118 "expr.y"
{ yyval.node = mkMapcoord(getImageNo(yypvt[-3].name), yypvt[-2].node, yypvt[-0].node); } break;
case 18:
# line 120 "expr.y"
{ yyval.node = mkempty(T_Color);         } break;
case 19:
# line 121 "expr.y"
{ yyval.node = mkun(T_Comb, yypvt[-0].node);         } break;
case 20:
# line 122 "expr.y"
{ yyval.node = mkun(T_Debug, yypvt[-0].node);        } break;
case 21:
# line 123 "expr.y"
{ yyval.node = mkun(T_Display, yypvt[-0].node);      } break;
case 22:
# line 124 "expr.y"
{ yyval.node = mkun(T_Explo, yypvt[-0].node);        } break;
case 23:
# line 125 "expr.y"
{ yyval.node = mkun(T_Free, yypvt[-0].node);         } break;
case 24:
# line 126 "expr.y"
{ yyval.node = mk(T_Genep, yypvt[-1].node, yypvt[-0].node);   } break;
case 25:
# line 127 "expr.y"
{ yyval.node = mk(T_Genps, yypvt[-1].node, yypvt[-0].node);      } break;
case 26:
# line 128 "expr.y"
{ yyval.node = mk(T_Get, yypvt[-1].node, yypvt[-0].node);        } break;
case 27:
# line 129 "expr.y"
{ yyval.node = mkempty(T_Gray);          } break;
case 28:
# line 130 "expr.y"
{ yyval.node = mkempty(T_Help);          } break;
case 29:
# line 131 "expr.y"
{ yyval.node = mkempty(T_List);          } break;
case 30:
# line 132 "expr.y"
{ yyval.node = mkun(T_Logfile, yypvt[-0].node);      } break;
case 31:
# line 133 "expr.y"
{ yyval.node = mkun(T_Luma, yypvt[-0].node);         } break;
case 32:
# line 134 "expr.y"
{ yyval.node = mk(T_Matte, yypvt[-1].node, yypvt[-0].node);     } break;
case 33:
# line 135 "expr.y"
{ yyval.node = mkun(T_Melt, yypvt[-0].node);         } break;
case 34:
# line 136 "expr.y"
{ yyval.node = mkempty(T_Mono);          } break;
case 35:
# line 137 "expr.y"
{ yyval.node = mkun(T_Ofmt, yypvt[-0].node);         } break;
case 36:
# line 138 "expr.y"
{ yyval.node = mkun(T_Oil, yypvt[-0].node);          } break;
case 37:
# line 139 "expr.y"
{ yyval.node = mk(T_Put, yypvt[-1].node, yypvt[-0].node);        } break;
case 38:
# line 140 "expr.y"
{ yyval.node = mkempty(T_Quit);          } break;
case 39:
# line 141 "expr.y"
{ yyval.node = mkun(T_Range, yypvt[-0].node);        } break;
case 40:
# line 142 "expr.y"
{ yyval.node = mk(T_Read, yypvt[-1].node, yypvt[-0].node);       } break;
case 41:
# line 143 "expr.y"
{ yyval.node = mkun(T_Shear, yypvt[-0].node);        } break;
case 42:
# line 144 "expr.y"
{ yyval.node = mkun(T_Signed, yypvt[-0].node);       } break;
case 43:
# line 145 "expr.y"
{ yyval.node = mk(T_Size, yypvt[-1].node, yypvt[-0].node);      } break;
case 44:
# line 146 "expr.y"
{ yyval.node = mkun(T_Slice, yypvt[-0].node);        } break;
case 45:
# line 147 "expr.y"
{ yyval.node = mkun(T_Store, yypvt[-0].node);        } break;
case 46:
# line 148 "expr.y"
{ yyval.node = mkun(T_Tile, yypvt[-0].node);         } break;
case 47:
# line 149 "expr.y"
{ yyval.node = mkun(T_Trunc, yypvt[-0].node);        } break;
case 48:
# line 150 "expr.y"
{ yyval.node = mkempty(T_Undo);          } break;
case 49:
# line 151 "expr.y"
{ yyval.node = mkun(T_Verbose, yypvt[-0].node);      } break;
case 50:
# line 152 "expr.y"
{ yyval.node = mkempty(T_Ver);           } break;
case 51:
# line 153 "expr.y"
{ yyval.node = mk(T_Write, yypvt[-1].node, yypvt[-0].node);      } break;
case 53:
# line 156 "expr.y"
{ yyval.node = mk(T_Comma, yypvt[-2].node, yypvt[-0].node);      } break;
case 55:
# line 159 "expr.y"
{ yyval.node = mkCond(yypvt[-4].node, yypvt[-2].node, yypvt[-0].node);       } break;
case 57:
# line 162 "expr.y"
{ yyval.node = mkAssign(yypvt[-2].name, yypvt[-0].node);         } break;
case 59:
# line 165 "expr.y"
{ yyval.node = mk(T_Land, yypvt[-2].node, yypvt[-0].node);       } break;
case 60:
# line 166 "expr.y"
{ yyval.node = mk(T_Lor, yypvt[-2].node, yypvt[-0].node);        } break;
case 62:
# line 169 "expr.y"
{ yyval.node = mk(T_Or, yypvt[-2].node, yypvt[-0].node);         } break;
case 64:
# line 172 "expr.y"
{ yyval.node = mk(T_Xor, yypvt[-2].node, yypvt[-0].node);        } break;
case 66:
# line 175 "expr.y"
{ yyval.node = mk(T_And, yypvt[-2].node, yypvt[-0].node);        } break;
case 68:
# line 178 "expr.y"
{ yyval.node = mk(T_Eq, yypvt[-2].node, yypvt[-0].node);         } break;
case 69:
# line 179 "expr.y"
{ yyval.node = mk(T_Ne, yypvt[-2].node, yypvt[-0].node);         } break;
case 71:
# line 182 "expr.y"
{ yyval.node = mk(T_Gt, yypvt[-2].node, yypvt[-0].node);         } break;
case 72:
# line 183 "expr.y"
{ yyval.node = mk(T_Lt, yypvt[-2].node, yypvt[-0].node);         } break;
case 73:
# line 184 "expr.y"
{ yyval.node = mk(T_Ge, yypvt[-2].node, yypvt[-0].node);         } break;
case 74:
# line 185 "expr.y"
{ yyval.node = mk(T_Le, yypvt[-2].node, yypvt[-0].node);         } break;
case 76:
# line 188 "expr.y"
{ yyval.node = mk(T_Lshift, yypvt[-2].node, yypvt[-0].node);     } break;
case 77:
# line 189 "expr.y"
{ yyval.node = mk(T_Rshift, yypvt[-2].node, yypvt[-0].node);     } break;
case 79:
# line 192 "expr.y"
{ yyval.node = mk(T_Add, yypvt[-2].node, yypvt[-0].node);        } break;
case 80:
# line 193 "expr.y"
{ yyval.node = mk(T_Sub, yypvt[-2].node, yypvt[-0].node);        } break;
case 82:
# line 196 "expr.y"
{ yyval.node = mk(T_Mul, yypvt[-2].node, yypvt[-0].node);        } break;
case 83:
# line 197 "expr.y"
{ yyval.node = mk(T_Div, yypvt[-2].node, yypvt[-0].node);        } break;
case 84:
# line 198 "expr.y"
{ yyval.node = mk(T_Mod, yypvt[-2].node, yypvt[-0].node);        } break;
case 86:
# line 201 "expr.y"
{ yyval.node = mk(T_Pow, yypvt[-2].node, yypvt[-0].node);        } break;
case 88:
# line 204 "expr.y"
{ yyval.node = mkempty(T_Xcoord);        } break;
case 89:
# line 205 "expr.y"
{ yyval.node = mkempty(T_Ycoord);        } break;
case 90:
# line 206 "expr.y"
{ yyval.node = mkempty(T_Prad);          } break;
case 91:
# line 207 "expr.y"
{ yyval.node = mkempty(T_Pang);          } break;
case 92:
# line 208 "expr.y"
{ yyval.node = mkInum(lastinum);         } break;
case 93:
# line 209 "expr.y"
{ yyval.node = mkFnum(lastfnum);         } break;
case 94:
# line 210 "expr.y"
{ yyval.node = yypvt[-0].node;                       } break;
case 95:
# line 211 "expr.y"
{ yyval.node = mkun(T_Neg, yypvt[-0].node);          } break;
case 96:
# line 212 "expr.y"
{ yyval.node = mkun(T_Bang, yypvt[-0].node);         } break;
case 97:
# line 213 "expr.y"
{ yyval.node = mkun(T_Not, yypvt[-0].node);          } break;
case 98:
# line 214 "expr.y"
{ yyval.node = mkun((enum tree) yypvt[-1].node, yypvt[-0].node); } break;
case 99:
# line 215 "expr.y"
{ yyval.node = mkCoord(yypvt[-1].num, yypvt[-0].node);          } break;
case 100:
# line 216 "expr.y"
{ yyval.node = mkVar(yypvt[-0].name);                } break;
case 101:
# line 217 "expr.y"
{ yyval.node = yypvt[-1].node;                       } break;
case 103:
# line 221 "expr.y"
{ if (!(yyval.node = mkBuiltin(yypvt[-9].name, 4, yypvt[-7].node, yypvt[-5].node, yypvt[-3].node, yypvt[-1].node))) YYERROR; } break;
case 104:
# line 223 "expr.y"
{ if (!(yyval.node = mkBuiltin(yypvt[-9].name, 4, yypvt[-7].node, yypvt[-5].node, yypvt[-3].node, yypvt[-1].node))) YYERROR; } break;
case 106:
# line 227 "expr.y"
{ if (!(yyval.node = mkBuiltin(yypvt[-5].name, 2, yypvt[-3].node, yypvt[-1].node))) YYERROR; } break;
case 107:
# line 229 "expr.y"
{ if (!(yyval.node = mkBuiltin(yypvt[-5].name, 2, yypvt[-3].node, yypvt[-1].node))) YYERROR; } break;
case 109:
# line 232 "expr.y"
{ if (!(yyval.node = mkBuiltin(yypvt[-3].name, 1, yypvt[-1].node))) YYERROR; } break;
case 110:
# line 233 "expr.y"
{ if (!(yyval.node = mkBuiltin(yypvt[-3].name, 1, yypvt[-1].node))) YYERROR; } break;
case 111:
# line 234 "expr.y"
{ if (!(yyval.node = mkBuiltin(yypvt[-3].name, 1, yypvt[-1].node))) YYERROR; } break;
case 112:
# line 235 "expr.y"
{ if (!(yyval.node = mkBuiltin(yypvt[-3].name, 1, yypvt[-1].node))) YYERROR; } break;
case 113:
# line 236 "expr.y"
{ if (!(yyval.node = mkBuiltin(yypvt[-3].name, 1, yypvt[-1].node))) YYERROR; } break;
case 114:
# line 238 "expr.y"
{ if (!(yyval.node = mkBuiltin(yypvt[-2].name, 0, 0)))  YYERROR; } break;
case 115:
# line 240 "expr.y"
{ yyval.node = mkempty(T_Bang);          } break;
case 116:
# line 241 "expr.y"
{ yyval.node = mkempty(T_Neg);           } break;
case 117:
# line 242 "expr.y"
{ yyval.node = mkempty(T_Not);           } break;
case 118:
# line 244 "expr.y"
{ yyval.node = NULL;                     } break;
case 121:
# line 248 "expr.y"
{ yyval.node = NULL;                     } break;
case 124:
# line 252 "expr.y"
{ yyval.node = NULL;                     } break;
case 125:
# line 253 "expr.y"
{ yyval.node = mkInum(lastinum);         } break;
case 126:
# line 254 "expr.y"
{ yyval.node = mkFnum(lastfnum);         } break;
case 127:
# line 256 "expr.y"
{ yyval.num = 0;                        } break;
case 128:
# line 257 "expr.y"
{ yyval.num = getImageNo(lastimage);    } break;
case 129:
# line 258 "expr.y"
{ yyval.num = lastinum + 1;             } break;
case 130:
# line 260 "expr.y"
{ yyval.node = NULL;                     } break;
case 131:
# line 261 "expr.y"
{ yyval.node = mkInum(getImageNo(lastimage));  } break;
case 132:
# line 262 "expr.y"
{ yyval.node = mkInum(lastinum + 1);     } break;
case 133:
# line 264 "expr.y"
{ yyval.node = mkempty(T_File);          } break;
case 134:
# line 266 "expr.y"
{ yyval.node = NULL;                     } break;
case 135:
# line 267 "expr.y"
{ yyval.node = mk(T_Polar, yypvt[-3].node, yypvt[-1].node);      } break;
case 136:
# line 268 "expr.y"
{ yyval.node = mk(T_Add, yypvt[-3].node, mk(T_Mul, yypvt[-1].node,
                                          mkInum(CurNew->height))); } break;
case 137:
# line 271 "expr.y"
{ yyval.node = mkempty(T_Rcut);          } break;
case 138:
# line 272 "expr.y"
{ yyval.node = mkempty(T_Rminmax);       } break;
case 139:
# line 273 "expr.y"
{ yyval.node = mkempty(T_Rwrap);         } break;
case 140:
# line 275 "expr.y"
{ yyval.node = mkInum(0);                } break;
case 141:
# line 276 "expr.y"
{ yyval.node = mkInum(1);                } break;
case 142:
# line 277 "expr.y"
{ yyval.node = mkInum(2);                } break;
case 143:
# line 279 "expr.y"
{ yyval.node = NULL;                     } break;
case 144:
# line 280 "expr.y"
{ yyval.node = mkempty(T_Plus);          } break;
case 145:
# line 281 "expr.y"
{ yyval.node = mkempty(T_Minus);         } break;
# line	531 "/usr/ccs/bin/yaccpar"
	}
	goto yystack;		/* reset registers in driver code */
}

